/**
* \file: device_list.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMM_MODEL_DEVICE_LIST_H
#define AMM_MODEL_DEVICE_LIST_H

#include "model/device.h"
#include "model/device_metadata.h"
#include "backends/device_handler.h"

typedef void* device_list_iterator_t;

error_code_t device_list_init(void);
void device_list_deinit(void);

device_t *device_list_add_device(const char* device_id, device_metadata_t *metadata,
		devicehandler_vtable_t *vtable);
void device_list_delete_device(device_t *device);

device_t* device_list_first_element(device_list_iterator_t *iterator);
device_t* device_list_next_element(device_list_iterator_t *iterator);

device_t* device_list_find_device(const char *device_id);

device_t* device_list_find_device_by_mountpoint(const char *mount_point);

#endif
